const wallet_trans_history_module = require("../model/wallet_trans_history_module");
const user_module = require("../model/user_module");
const { getUserRandomToken } = require('../helper/helper_functions');

async function updateUserWallet(userId, winAmount, msg, openResultToken, bidTxId) {
    await user_module.updateOne(
        { _id: userId },
        { $inc: { wallet_balance: winAmount } }
    );

    const history = {
        userDB_id: userId,
        amount: winAmount,
        transaction_type: 1,
        transaction_note: msg,
        amount_status: 12,
        tx_request_number: getUserRandomToken(),
        open_result_token: openResultToken,
        bid_tx_id: bidTxId,
    };

    await wallet_trans_history_module.create(history);
}

module.exports = { updateUserWallet };